/* l100n 1.0 - unusual JavaScript library for pure client-side localization by css-selectors
 * Full description in Russian: http://vas3k.ru/dev/l100n
 * Licensed under the LGPL licenses:
 *   http://www.gnu.org/licenses/lgpl.html
 */
l100n = {
locale: get_cookie_locale(), default_locale: "en", always_localize: [],
pages: {
"main": {              // Page codename
    "title": {selector: "title", en: "KSE Device User Page", ru: "KSE Device Страница пользователя"},
    "autoupdate": { selector: "#autoupdate", en: "Autoupdate", ru: "Автообновление"},
    //"language": { selector: "#language", en: "en", ru: "рус"},
    "access_control": { selector: "#access_control", en: "Access control:", ru: "Уровень доступа:"},
    "Device Description": {selector: "#Device_Description", en: "Device Description", ru: "Общие параметры"},
    "time": {selector: "#time", en: "Date and Time ", ru: "Дата и время "},
    "Revision_number": {selector: "#Revision_number", en: "Revision Number ", ru: "Номер ревизии "},
    "uid": {selector: "#uid", en: "UID ", ru: "UID "},
    "interface_language": {selector: "#interface_language", en: "Interface language ", ru: "Язык интерфейса "},
    "sw_version": {selector: "#sw_version", en: "SW version ", ru: "Версия системного ПО "},
    "battery_voltage": {selector: "#battery_voltage", en: "Battery voltage, V ", ru: "Напряжение батареи, В "},
    "command": {selector: "#command", en: "Command ", ru: "Команда "},
    "password": {selector: "#password", en: "Password ", ru: "Пароль "},
    "restore_default_settings": {selector: "#restore_default_settings", en: "Restore Default Settings ", ru: "Восcтановить настройки по умолчанию "},
    "Boards_Types": {selector: "#Boards_Types", en: "Modules Types", ru: "Типы модулей"},
    "main_board": {selector: "#main_board", en: "Main Module ", ru: "Базовый модуль "},
    "board_0": {selector: "#board_module_0", en: "Extention Module 0 ", ru: "Модуль расширения 0 "},
    "board_1": {selector: "#board_module_1", en: "Extention Module 1 ", ru: "Модуль расширения 1 "},
    "board_2": {selector: "#board_module_2", en: "Extention Module 2 ", ru: "Модуль расширения 2 "},
    "board_3": {selector: "#board_module_3", en: "Extention Module 3 ", ru: "Модуль расширения 3 "},
    "board_4": {selector: "#board_module_4", en: "Extention Module 4 ", ru: "Модуль расширения 4 "},
    "board_5": {selector: "#board_module_5", en: "Extention Module 5 ", ru: "Модуль расширения 5 "},
    "board_6": {selector: "#board_module_6", en: "Extention Module 6 ", ru: "Модуль расширения 6 "},
    "board_7": {selector: "#board_module_7", en: "Extention Module 7 ", ru: "Модуль расширения 7 "},
    "board_8": {selector: "#board_module_8", en: "Extention Module 8 ", ru: "Модуль расширения 8 "},
    "Network Settings": {selector: "#Network_Settings", en: "Network Settings", ru: "Настройки сети"},
    "Modbus Settings": {en: "Modbus Settings", ru: "Настройки Modbus"},
    "Modbus TCP GW Serial Settings": {en: "TCP Gateway", ru: "Настройки шлюза TCP"},
    "Modbus TCP Slave": {en: "Modbus TCP Slave", ru: "Ведомый Modbus TCP"},
    "rs_enable": {selector: "#rs_enable", en: "Enable ", ru: "Задействовать "},
    "rs_data_rate": {selector: "#rs_data_rate", en: "Data rate, kbit/s ", ru: "Скорость передачи, кбит/с "},
    "rs_parity": {selector: "#rs_parity", en: "Parity ", ru: "Четность "},
    "rs_stop_bits": {selector: "#rs_stop_bits", en: "Stop bits ", ru: "Стоп биты "},
    "rs_slave_enable": {en: "Enable ", ru: "Задействовать "},
    "rs_modbus_settings": {selector: "#rs_modbus_settings", en: "Slave ", ru: "Ведомый "},
    "rs_master_settings": {selector: "#rs_master_settings", en: "Master ", ru: "Ведущий "},
    "rs_device_address": {selector: "#rs_device_address", en: "Device address ", ru: "Адрес устройства "},
    "rs_answer_delay": {selector: "#rs_answer_delay", en: "Answer Delay, ms ", ru: "Задержка ответа, мс "},
    "rs_poll_timeout": {selector: "#rs_poll_timeout", en: "Poll Timeout, s ", ru: "Время ожидания опроса, с "},
    "rs_master_enable": {selector: "#rs_master_enable", en: "Enable ", ru: "Задействовать "},
    "rs_startup_delay": {selector: "#rs_startup_delay", en: "Startup Delay, ms ", ru: "Задержка запуска, мс "},
    "rs_response_timeout": {selector: "#rs_response_timeout", en: "Response Timeout, ms ", ru: "Ожидание отклика, мс  "},
    "rs_interbyte_timeout": {selector: "#rs_interbyte_timeout", en: "Additional Interbyte Timeout, ms ", ru: "Дополнительный тайм-аут ожидания байта, мс "},
    "rs_retry_count": {selector: "#rs_retry_count", en: "Retry Count ", ru: "Количество повторов "},
    "rs_gw_enable": {en: "Enable ", ru: "Задействовать "},
    "rs_gw_start_addr": {en: "Start address", ru: "Начальный адрес"},
    "rs_gw_end_addr": {en: "End address", ru: "Конечный адрес"},
    "rs_gw_Address_Offset": {en: "Address Offset", ru: "Смещение диапазона"},
    "rs_gw_Broadcast": {en: "Enable Broadcast", ru: "Задействовать Broadcast"},
    "rs_gw_ip_addr_number": {en: "IP address number", ru: "Число IP адреса"},
    "rs_gw_ip_port": {en: "IP port", ru: "IP порт"},
    "ethernet_ip_address": {selector: "#ethernet_ip_address", en: "IP Address ", ru: "IP адрес "},
    "ethernet_net_mask": {selector: "#ethernet_net_mask", en: "Net Mask ", ru: "Маска сети "},
    "ethernet_gateway": {selector: "#ethernet_gateway", en: "Gateway ", ru: "Шлюз "},
    "ethernet_dns1": {selector: "#ethernet_dns1", en: "DNS 1 ", ru: "DNS 1 "},
    "ethernet_dns2": {selector: "#ethernet_dns2", en: "DNS 2 ", ru: "DNS 2 "},
    "ethernet_dhcp_enable": {selector: "#ethernet_dhcp_enable", en: "DHCP Enable ", ru: "DHCP "},
    "can_enable": {selector: "#can_enable", en: "Enable: ", ru: "Задействовать: "},
    "can_data_rate": {selector: "#can_data_rate", en: "Data rate, kbit/s ", ru: "Скорость передачи, кбит/с "},
    "can_settings": {selector: "#can_settings", en: "CANopen settings ", ru: "CANopen "},
    "node_id": {selector: "#node_id", en: "Node id", ru: "Node id"},
    "node_1": {selector: "#node_1", en: "Node id 1 ", ru: "Node id 1 "},
    "node_2": {selector: "#node_2", en: "Node id 2 ", ru: "Node id 2 "},
    "node_3": {selector: "#node_3", en: "Node id 3 ", ru: "Node id 3 "},
    "node_4": {selector: "#node_4", en: "Node id 4 ", ru: "Node id 4 "},
    "node_5": {selector: "#node_5", en: "Node id 5 ", ru: "Node id 5 "},
    "node_6": {selector: "#node_6", en: "Node id 6 ", ru: "Node id 6 "},
    "node_7": {selector: "#node_7", en: "Node id 7 ", ru: "Node id 7 "},
    "node_8": {selector: "#node_8", en: "Node id 8 ", ru: "Node id 8 "},
    "slave_enable": {en: "Enable ", ru: "Задействовать "},
    "slave_device_address": {en: "Device address ", ru: "Адрес устройства "},
    "slave_poll": {en: "Poll Timeout ", ru: "Тайм-аут опроса мастером, с "},
    "Boards_Settings": {selector: "#Boards_Settings", en: "I/O Modules Settings", ru: "Настройки модулей расширения"},
    "Heating_Lines": {selector: "#Heating_Lines", en: "Heating Lines", ru: "Линии обогрева"},
    "Heating": {selector: "#Heating", en: "Heating", ru: "Обогрев"},
    "Product_Code": {selector: "#Product_Code", en: "Product Code ", ru: "Код устройства "},
    "App_version": {selector: "#App_version", en: "App version ", ru: "Версия прикладного ПО "},
    "index_error": {en: "Index error", ru: "Ошибка индекса"},
}, "ui": {
    "apply_button": {en: "apply", ru: "Применить"},
    "show_password": {en: "show password", ru: "показать пароль"},
    "validator_pass": {en: "4 digits", ru: "4 цифры"},
    "ip_address_pass": {en: "octet number must be between [0-255]", ru: "Четыре числа в интервале [0-255]"},
    "response error": {en: "Error in response from server.", ru: "Ошибка в ответе с сервера."},
    "reload page": {en: "Error in response from server. Reload page?", ru: "Ошибка в ответе с сервера. Перезагрузить страницу?"},
    "ACCESS DENIED": {en: "ACCESS DENIED", ru: "Ошибка доступа"},
    "ACCESS CONFIRMED": {en: "ACCESS CONFIRMED", ru: "Доступ разрешен"},
    "Invalid data format.": {en: "Invalid data format.", ru: "Неверный формат данных"},
    "Check device connection...": {en: "Check device connection...", ru: "Проверьте соединение с контроллером..."},
    "request_abort": {en: "Request aborted", ru: "Запрос прерван"},
    "No data":  {en: "No data", ru: "Нет данных"},
    "Passwords are different.": {en: "Passwords are different.", ru: "Пароли не совпадают."},
    "Password are changed.": {en: "Password are changed.", ru: "Пароль изменен."},
    "Change password.": {en: "Change password", ru: "Смена пароля"},
    "Ok": {en: "OK", ru: "Применить"},
    "Cancel": {en: "Cancel", ru: "Отмена"},
    "hex_dec_number": {en: "Hex or Dec number", ru: "Число в шестнадцатеричном или десятичном формате."},
    "range_localization": {en: "Please enter a value in interval ", ru: "Введите число в интервале "},
    "Login": {en: "Login", ru: "Вход"},
    "Expert_page": {selector: "#Expert_page", en: "Expert page", ru: "Расширенные настройки"},
    "modbus_mapping_page": {selector: "#Modbus_mappings", en: "View Modbus mappings", ru: "Просмотр \"Modbus mappings\""},
    "Login_header": {en: "Please enter password", ru: "Требуется ввод пароля"},
    "Set datetime manually": {en: "Set Manually", ru: "Установить вручную"},
    "Synchronize": {en: "Set from PC", ru: "Принять время ПК"},
    "Restart and reload": {en: "Restart device and reload web page", ru: "Перезагрузите устройство и обновите страницу"},
    "Restore_params_hint": {en: "Enter 'load' word and apply for restore to default settings ", ru: "Введите слово 'load' и нажмите применить для востановления настроек по умолчанию"},
},"configuration": {
    "access_control_on": {en: "Access Control On", ru: "Включить контроль доступа"},
    "access_control_off": {en: "Access Control Off", ru: "Отключить контроль доступа"},
    "off": {en: "Off", ru: "выкл"},
    "on": {en: "On", ru: "вкл"},
    "yes": {en: "True", ru: "да"},
    "no": {en: "False", ru: "нет"},
    "user": {en: "User", ru: "пользователь"},
    "admin": {en: "Admin", ru: "администратор"},
    "even": {en: "Even", ru: "четный"},
    "odd": {en: "Odd", ru: "нечетный"},
    "access_level_reset": {en: "Access Level Reset", ru: "Сбросить уровень доступа"},
    "change_password": {en: "Change Password", ru: "Сменить пароль доступа"},
    "counter_reset": {en: "Counter Reset", ru: "Сброс накопления счетчиков"},
    "download_settings": {en: "Download Settings", ru: "Скачать настройки"},
    "upload_settings": {en: "Upload Settings", ru: "Записать настройки"},
    "reboot": {en: "Reboot", ru: "Перезагрузка"},
    "dummy": {en: "0 - Dummy", ru: "0 - Резерв"},
    "slot_absent": {en: "Slot absent", ru: "Отсутствует слот"},
    "channel": {en: "Channel", ru: "Канал"},
    "9.6": {en: "9.6", ru: "9,6"},
	"19.2": {en: "19.2", ru: "19,2"},
	"38.4": {en: "38.4", ru: "38,4"},
	"57.6": {en: "57.6", ru: "57,6"},
    "115.2": {en: "115.2", ru: "115,2"},
    "500µA": {en: "0.5mA", ru: "0,5мА"},
    "125µA": {en: "0.125mA", ru: "0,125мА"},
    "H-5A/L-0,1A": {en: "H-5A/L-0.1A", ru: "H-5A/L-0,1A"},
    "H-1,25A/L-0,025A": {en: "H-1.25A/L-0.025A", ru: "H-1,25A/L-0,025A"},
    "ua_absent": {en: "Absent", ru: "отсутствует"},
    "ua_start": {en: "Start", ru: "старт"},
    "ua_stop": {en: "Stop", ru: "стоп"},
    "NO_ERROR": {en: "No error", ru: "Ошибка отсутствует"},
    "HW_ERROR_NO_MAINS_POWER": {en: "Absence of main power", ru: "Отсутствие основного питания"},
    "HW_ERROR_FLASH": {en: "FLASH-memory hardware error", ru: "Аппаратная ошибка FLASH-памяти"},
    "HW_ERROR_CRITICAL_STORAGE": {en: "Critical storage hardware error", ru: "Аппаратная ошибка энергонезависимой памяти"},
    "HW_ERROR_EXT_RAM": {en: "External RAM hardware error", ru: "Аппаратная ошибка внешнего ОЗУ"},
    "HW_ERROR_UNSPECIFIED": {en: "Unspecified malfunction", ru: "Недиагностируемая неисправность"},
    "HW_ERROR_BATTERY": {en: "Battery error", ru: "Ошибка батареи"},
    "HW_ERROR_RTC": {en: "RTC", ru: "RTC"},
    "HW_ERROR_COMM": {en: "Communication error", ru: "Ошибка коммуникации"},
    "HW_ERROR_MODULE_1": {en: "Module 1 error", ru: "Ошибка платы расширения №1"},
    "HW_ERROR_MODULE_2": {en: "Module 2 error", ru: "Ошибка платы расширения №2"},
    "HW_ERROR_MODULE_3": {en: "Module 3 error", ru: "Ошибка платы расширения №3"},
    "HW_ERROR_MODULE_4": {en: "Module 4 error", ru: "Ошибка платы расширения №4"},
    "HW_ERROR_MODULE_5": {en: "Module 5 error", ru: "Ошибка платы расширения №5"},
    "HW_ERROR_MODULE_6": {en: "Module 6 error", ru: "Ошибка платы расширения №6"},
    "HW_ERROR_MODULE_7": {en: "Module 7 error", ru: "Ошибка платы расширения №7"},
    "HW_ERROR_MODULE_8": {en: "Module 8 error", ru: "Ошибка платы расширения №8"},
    "SW_ERROR_NEED_RESTART": {en: "Need restart", ru: "Необходима перезагрузка"},
    "SW_ERROR_FS": {en: "Filesystem error", ru: "Ошибка файловой системы"},
    "SW_ERROR_RAM": {en: "RAM error", ru: "Ошибка ОЗУ"},
    "SW_ERROR_RESCUE_FROM_FAILURE": {en: "Rescue from failure", ru: "Восстановление после сбоя"},
    "SW_ERROR_EXCEPTION": {en: "Exception situation", ru: "Исключительная ситуация"},
    "SW_ERROR_INCOMTATIBLE_SETTINGS": {en: "Incomtatible settings", ru: "Несовместимые настройки"},
    "SW_ERROR_TIME": {en: "Timing error", ru: "Ошибка определения времени"},
    "SW_ERROR_APPLICATION": {en: "Application software error", ru: "Ошибка прикладного ПО"},
    "NO": {en: "NO", ru: "НО"},
    "NC": {en: "NC", ru: "НЗ"},
},"MDR_configuration": {
    "Heater Off": {en: "Heater Off", ru: "Постоянно выкл"},
    "Heater On": {en: "Heater On", ru: "Постоянно вкл"},
    "error_status": {en: "ERROR", ru: "ОШИБКА"},
    "First": {en: "First", ru: "Первый"},
    "Second": {en: "Second", ru: "Второй"},
    "Average": {en: "Average", ru: "Среднее по двум"},
    "Min": {en: "Min", ru: "Минимальный из двух"},
    "Max": {en: "Max", ru: "Максимальный из двух"},
    "Running Hours Reset": {en: "Running Hours Reset", ru: "Сброс счётчика моточасов"},
    "Switch On Counter Reset": {en: "Switch On Counter Reset", ru: "Сброс счетчика включений"},
    "Discret I/O": {en: "Discret I/O", ru: "Дискретные вх/вых"},
    "Analog Inputs": {en: "Analog Inputs", ru: "Аналоговые входы"},
} ,"user_page": {
    "module": {en: "Module", ru: "Модуль"},
    "value": {en: "Value ", ru: "Значение "},
    "invert_polarity": {en: "Invert Polarity ", ru: "Смена полярности "},
    "Filter time": {en: "Filter Time", ru: "Время фильтрации"},
    "Input Sensor": {en: "Sensor Type", ru: "Тип датчика"},
    "Filter time, ms": {en: "Filter Time, ms ", ru: "Время фильтрации, мс "},
    "Error mode": {en: "Error Mode ", ru: "Режим безопасности "},
    "Error value": {en: "Error Value ", ru: "Безопасное состояние "},
    "Filter mask": {en: "Filter Mask ", ru: "Маскирование управления "},
    "Channel:": {en: "Channel ", ru: "Канал "},
    "Scaling": {en: "Scaling ", ru: "Масштабирование "},
    "Offset": {en: "Offset ", ru: "Смещение "},
    "Deadband Reference": {en: "Deadband Reference ", ru: "Диапазон "},
    "Deadband, %": {en: "Deadband, % ", ru: "Зона нечувствительности, % "},
    "Settings": {en: "Settings", ru: "Настройки"},
    "Scheme": {en: "Scheme ", ru: "Схема "},
    "Current range": {en: "Current range Ia,Ib,Ic ", ru: "Диапазон тока Ia,Ib,Ic"},
    "Current range Lkg": {en: "Current range Id ", ru: "Диапазон тока Id "},
    "CTR": {en: "CTR Ia,Ib,Ic ", ru: "CTR Ia,Ib,Ic "},
    "CTR Lkg": {en: "CTR Id ", ru: "CTR Id "},
    "VTR": {en: "VTR ", ru: "VTR "},
    "Deadband Settings": {en: "Deadband", ru: "Зоны нечувствительности"},
    "C V PF": {en: "Current, Voltage, PF", ru: "Ток, напряжение, КМ"},
    "Power": {en: "Power", ru: "Мощность"},
    "Quality": {en: "Quality", ru: "Качество"},
    "Energy": {en: "Energy", ru: "Энергия"},
    "Statistics": {en: "Misc", ru: "Разное"},
    "Upper Limit": {en: "Upper Limit", ru: "Верхний предел"},
    "Lower Limit": {en: "Lower Limit", ru: "Нижний предел"},
    "ext_Settings": {en: "Sensor Select", ru: "Выбор датчика"},
    "AI Read Float": {en: "AI Read Float", ru: "Значение аналогов"},
    "not selected": {en: "Not Selected", ru: "Не выбран"},
    "ext_Channel": {en: "Channel", ru: "Канал"},
    "ext_Channels_header": {en: "External I/O Settings", ru: "Настройки внешних вводов/выводов"},
    "int_Channels_header": {en: "Internal I/O Settings", ru: "Настройки внутренних вводов/выводов"},
    "1 Wire accordion header": {en: "1-Wire Sensors", ru: "Датчики 1-Wire"},
    "Operating Hours": {en: "Operating Hours", ru: "Моточасы фазы"},
    "Total Operating Hours": {en: "Total Operating Hours", ru: "Общие моточасы"},
    "Current": {en: "Current", ru: "Токи"},
    "L2N Voltage": {en: "Line-to-Neutral Voltage", ru: "Фазное напряжение"},
    "L2L Voltage": {en: "Line-to-Line Voltage", ru: "Линейное напряжение"},
    "Power Factor": {en: "Power Factor", ru: "Коэффициент мощности"},
    "Active": {en: "Active", ru: "Активная"},
    "Reactive": {en: "Reactive", ru: "Реактивная"},
    "Apparent": {en: "Apparent", ru: "Суммарная"},
    "Pulse Qty": {en: "Pulse Qty", ru: "Вес разряда"},
    "Frequency": {en: "Frequency", ru: "Частота"},
    "THD Current": {en: "THD Current", ru: "КНИ тока"},
    "THD Voltage": {en: "THD Voltage", ru: "КНИ напряжения"},
    "Current ranges": {en: "Input ranges", ru: "Диапазоны тока"},
    "Transformation ratios": {en: "Transformation ratios", ru: "Коэффициенты трансформации"},
    "state": {en: "State", ru: "Состояние"},
    "input state": {en: "Input", ru: "Вход"},
    "output state": {en: "Output", ru: "Выход"},
    "di state": {en: "DI State", ru: "Значения DI"},
    "di Settings": {en: "DI Settings", ru: "Настройки DI"},
    "Symmetrical components": {en: "Symmetrical components", ru: "Симметричные компоненты"},
    "Alarm relay": {en: "Alarm relay", ru: "Аварийное реле"},
    "Lines Settings": {selector: "#Lines_Settings", en: "Lines Settings", ru: "Настройка каналов"},
    "RTD Sensors": {en: "Sensors", ru: "Датчики"},
    "CHANNEL_OK": {en: "OK", ru: "В норме"},
    "CHANNEL_FAULT": {en: "Channel Fault", ru: "Ошибка канала"},
    "CHANNEL_LOW_FAILURE": {en: "Channel Low Failure", ru: "Ошибка низкого уровня"},
    "CHANNEL_LOW": {en: "Channel Low", ru: "Низкий уровень"},
    "CHANNEL_HIGH": {en: "Channel High", ru: "Высокий уровень"},
    "CHANNEL_HIGH_FAILURE": {en: "Channel Fault", ru: "Ошибка высокого уровня"},
    "CHANNEL_NC": {en: "Channel not Connected", ru: "Обрыв"},
    "CHANNEL_SHORT_CIRCUIT": {en: "Channel Short Circuit", ru: "Короткое замыкание"},
} ,"units": {
    "V": {en: "V", ru: "В"},
    "kW": {en: "kW", ru: "кВт"},
    "kvar": {en: "kvar", ru: "квар"},
    "kVA": {en: "kVA", ru: "кВА"},
    "kWh": {en: "kWh", ru: "кВтч"},
    "kvarh": {en: "kvarh", ru: "кварч"},
    "kVAh": {en: "kVAh", ru: "кВАч"},
    "Hz": {en: "Hz", ru: "Гц"},
    "mA": {en: "mA", ru: "мА"},
    "kvar/h": {en: "kvar/h", ru: "квар/ч"},
    "kVA/h": {en: "kVA/h", ru: "кВА/ч"},
    "kW/h": {en: "kW/h", ru: "кВт/ч"},
    "ms": {en: "ms", ru: "мс"},
},
"heating lines": {
    "Line": {en: "Line", ru: "Канал управления"},
    "Live View": {en: "Live View", ru: "Текущие параметры"},
    "Alarms": {en: "Alarms and Trips", ru: "Аварийные сигналы"},
    "Alarm Settings": {en: "Alarm Settings", ru: "Настройки пределов"},
    "HW Settings": {en: "HW Settings", ru: "Настройки вх/вых"},
    "Line Settings": {en: "Line Settings", ru: "Настройки линии"},
    "Control mode settings" : {en: "Control Mode Settings", ru: "Настройки режима управления"},
    "Other settings" : {en: "Other Settings", ru: "Остальные настройки"},
    "Calibration tab": {en: "Calibration", ru: "Калибровка"},
    "Cable Current Calibration": {en: "Cable Current Calibration", ru: "Калибровка по току кабеля"},
    "Control": {en: "Control", ru: "Управление"},
    "Name": {en: "Name", ru: "Название"},
    "Alarm or Trip Present": {en: "Alarm or Trip Present", ru: "Присутствует авария или защитное отключение"},
    "Actual Control Mode": {en: "Actual Control Mode", ru: "Текущий режим управления"},
    "Safe Mode": {en: "Safe Mode", ru: "Безопасный режим"},
    "Output State": {en: "Line Output State", ru: "Состояние выхода линии"},
    "Output Channel Status": {en: "DO Channel Status", ru: "Состояние дискретного выхода"},
    "Contactor State": {en: "Contactor State", ru: "Состояние контактора"},
    "Trip Reset": {en: "Trip Reset", ru: "Сброс защитного отключения"},
    "Remote": {en: "Remote", ru: "Дистанционный"},
    "Temperature PV": {en: "Temperature PV", ru: "Значения температуры"},
    "Process Temperature": {en: "Process Temperature, °C", ru: "Расчетная температура, °C"},
    "Temperature 1": {en: "Temperature 1", ru: "Температура 1"},
    "Temperature 2": {en: "Temperature 2", ru: "Температура 2"},
    "Temperature 1 C": {en: "Temperature 1, °C", ru: "Температура 1, °C"},
    "Temperature 2 C": {en: "Temperature 2, °C", ru: "Температура 2, °C"},
    "Temperature 1 Select": {en: "Temperature 1 Select", ru: "Выбор датчика температуры 1"},
    "Temperature 2 Select": {en: "Temperature 2 Select", ru: "Выбор датчика температуры 2"},
    "Current PV": {en: "Current PV", ru: "Значения тока"},
    "Load Current": {en: "Load Current, A", ru: "Ток нагрузки, А"},
    "Leakage Current": {en: "Leakage Current, mA", ru: "Ток утечки, мА"},
    "Misc PV": {en: "Misc PV", ru: "Прочие значения"},
    "PWM Val": {en: "PWM Val, %", ru: "ШИМ, %"},
    "Output On Count": {en: "Output On Count", ru: "Счётчик включений"},
    "Output On Count Alarm": {en: "Output On Count", ru: "Превышение счётчика включений"},
    "Running Hours": {en: "Running Hours, h", ru: "Моточасы, ч"},
    "Running Hours Alarm": {en: "Running Hours", ru: "Превышение моточасов"},
    "Temperature Alarms": {en: "Temperature Alarms", ru: "Аварии температуры"},
    "Alarm": {en: "Alarm", ru: "Авария"},
    "Trip": {en: "Trip", ru: "Защитное отключение"},
    "Process Temperature Fault": {en: "Process Temperature Fault", ru: "Ошибка расчёта температуры процесса"},
    "Temperature 1 Fault": {en: "Temperature 1 Fault", ru: "Температура 1 отказ"},
    "Temperature 1 High": {en: "Temperature 1 High", ru: "Температура 1 верхний предел"},
    "Temperature 1 Low": {en: "Temperature 1 Low", ru: "Температура 1 нижний предел"},
    "Temperature 2 Fault": {en: "Temperature 2 Fault", ru: "Температура 2 отказ"},
    "Temperature 2 High": {en: "Temperature 2 High", ru: "Температура 2 верхний предел"},
    "Temperature 2 Low": {en: "Temperature 2 Low", ru: "Температура 2 нижний предел"},
    "Current Alarms": {en: "Current Alarms", ru: "Аварии токов"},
    "Load Current High": {en: "Load Current High", ru: "Ток нагрузки верхний предел"},
    "Load Current Low": {en: "Load Current Low", ru: "Ток нагрузки нижний предел"},
    "Leakage Current High": {en: "Leakage Current High", ru: "Ток утечки верхний предел"},
    "Output Off Current High": {en: "Output Off Current High", ru: "Ток при отключенной нагрузке верхний предел"},
    "Misc Alarms": {en: "Misc Alarms", ru: "Прочие аварии"},
    "Misconfig": {en: "Misconfig", ru: "Неправильная конфигурация"},
    "Circuitbreaker OF": {en: "Circuitbreaker OF", ru: "Автомат отключен"},
    "Circuitbreaker SD": {en: "Circuitbreaker SD", ru: "Аварийное отключение автомата"},
    "Contactor Fault": {en: "Contactor Fault", ru: "Отказ контактора"},
    "Temperature Trips Enable": {en: "Temperature Trips Enable", ru: "Разрешить отключение по температуре"},
    "Current Trips Enable": {en: "Current Trips Enable", ru: "Режим защитного отключение по току"},
    "Temperature Alarm Settings": {en: "Temperature Alarm Settings", ru: "Уставка температуры"},
    "Temperature High": {en: "Temperature High, °C", ru: "Температура верхний предел, °C"},
    "Temperature Low": {en: "Temperature Low, °C", ru: "Температура нижний предел, °C"},
    "Current Alarm Settings": {en: "Current Alarm Settings", ru: "Уставка тока"},
    "Misc Alarm Settings": {en: "Misc Alarm Settings", ru: "Прочие настройки аварийных пределов"},
    "Alarm Hold Time": {en: "Alarm Hold Time, s", ru: "Минимальное время удержания флагов аварий, с"},
    "alarm_enable": {en: "Enable", ru: "Ввод линии в работу"},
    "Output Mode": {en: "Output Mode", ru: "Режим выхода"},
    "Soft Start": {en: "Soft Start", ru: "Снижения стартовых токов"},
    "Relay": {en: "Relay", ru: "Нормальный"},
    "Average Current Limit": {en: "Average Current Limit", ru: "Ограничения среднего тока"},
    "Current Limit": {en: "Current Limit, A", ru: "Ограничение Тока, А"},
    "Voltage": {en: "Voltage, V", ru: "Напряжение, В"},
    "Startup Delay": {en: "Startup Delay, s", ru: "Задержка первого включения, c"},
    "Control Mode": {en: "Control Mode", ru: "Режим управления"},
    "Safe Mode": {en: "Safe Mode", ru: "Безопасный режим"},
    "PWM": {en: "PWM", ru: "ШИМ"},
    "Cable Current": {en: "Cable Current", ru: "По току самрег. кабеля"},
    "PWM Period": {en: "PWM Period, s", ru: "Период ШИМ, c"},
    "PWM Duty Cycle": {en: "PWM Duty Cycle, %", ru: "Рабочий цикл ШИМ, %"},
    "Temp Relay": {en: "Thermal Relay", ru: "Режим термостата"},
    "Process Temperature Calc Mode": {en: "Process Temperature Calc Mode", ru: "Режим расчета температуры процесса"},
    "Allow Incomplete Sensors": {en: "Allow Incomplete Sensors", ru: "Разрешение работы при отказе одного датчика"},
    "Process Temp Set-point": {en: "Process Temp Set-point", ru: "Уставка температуры"},
    "Process Temp Set-point C": {en: "Process Temp Set-point, °C", ru: "Уставка температуры, °C"},
    "Hysteresis Positive": {en: "Hysteresis Positive, °C", ru: "Гистерезис положительный, °C"},
    "Hysteresis Negative": {en: "Hysteresis Negative, °C", ru: "Гистерезис отрицательный, °C"},
    "PWM Proportional": {en: "PWM Proportional", ru: "Пропорциональный ШИМ"},
    "Proportional High Temp": {en: "Proportional High Temp, °C", ru: "Верхняя граница температуры, °C"},
    "Proportional High PWM Duty Cycle": {en: "Proportional High PWM Duty Cycle, %", ru: "Рабочий цикл для верхней границы, %"},
    "Proportional Low Temp": {en: "Proportional Low Temp, °C", ru: "Нижняя граница температуры, °C"},
    "Proportional Low PWM Duty Cycle": {en: "Proportional Low PWM Duty Cycle, %", ru: "Рабочий цикл для нижней границы, %"},
    "HL DeadBand Settings": {en: "DeadBand Settings", ru: "Настройка зон нечувствительности"},
    "Temperature Deadband Reference": {en: "Temperature Deadband Reference, °C", ru: "Опорный диапазон нечувствительности по температуре, °C"},
    "Temperature Deadband": {en: "Temperature Deadband, %", ru: "Зона нечувствительности по температуре, %"},
    "Current Deadband Reference": {en: "Current Deadband Reference, A", ru: "Опорный диапазон нечувствительности по току нагрузки, А"},
    "Current Deadband": {en: "Current Deadband, %", ru: "Зона нечувствительности по току нагрузки, %"},
    "Leakage Current Deadband Reference": {en: "Leakage Current Deadband Reference, mA", ru: "Опорный диапазон нечувствительности по току утечки, мА"},
    "Leakage Current Deadband": {en: "Leakage Current Deadband, %", ru: "Зона нечувствительности по току утечки, %"},
    "Minimum Output Hold Time": {en: "Minimum Output Hold Time, s", ru: "Минимальное время удержания выхода, с"},
    "Output Select": {en: "Output Select", ru: "Выбор выхода"},
    "Input Select": {en: "Input Select", ru: "Выбор входа"},
    "Heatline_Control": {en: "Control", ru: "Управление"},
    "Heatline_Command": {en: "Command", ru: "Команда"},
    "Remote Output Control": {en: "Remote Output Control", ru: "Удаленное управление выходом"},
    "Temperature 1 Sensor Type": {en: "Temperature \"TI1\" Sensor Type", ru: "Тип датчика \"TI1\""},
    "Temperature 2 Sensor Type": {en: "Temperature \"TI2\" Sensor Type", ru: "Тип датчика \"TI2\""},
    "Load Current Filter Time": {en: "Load Current Filter Time, ms", ru: "Время фильтрации тока нагрузки, мс"},
    "Leakage Current Filter Time": {en: "Leakage Current Filter Time, ms", ru: "Время фильтрации тока утечки, мс"},
    "Measure current": {en: "Measure current", ru: "Измерить ток"},
    "Instant current": {en: "Instant current", ru: "Мгновенный ток"},
    "Heatline_Settings": {en: "Settings", ru: "Настройки линии"},
    "Heating Line": {en: "Heating Line", ru: "Канал управления"},

    "Trip Off": {en: "Trip Off", ru: "Выключено"},
    "Trip On": {en: "Trip On", ru: "Включено"},
    "Trip On and Autoreturn": {en: "Trip On and Autoreturn", ru: "Автовосстановление"},
    "Temperature Limiter C": {en: "Temperature Limiter, °C", ru: "Температура ограничения нагрева, °C"},
    "Temperature Limiter Fault": {en: "Temperature Limiter Fault", ru: "Отказ датчика Температуры ограничения нагрева"},
    "Temperature Limiter High": {en: "Temperature Limiter High", ru: "Верхний предел Температуры ограничения нагрева"},
    "Temperature Trips Mode": {en: "Temperature Trips Mode", ru: "Режим защиты по температуре"},
    "Temperature Hysteresis Negative": {en: "Temperature Hysteresis Negative", ru: "Температура. Гистерезис отрицательный, °C"},
    "Temperature Limiter Hysteresis Negative": {en: "Temperature Limiter Hysteresis Negative", ru: "Температура ограничения нагрева. Гистерезис отрицательный, °C"},
    "Temperature Limiter Select": {en: "Temperature Limiter Select", ru: "Выбор датчика температуры ограничения нагрева"},
    "DO Invert Polarity": {en: "Load Connection", ru: "Подключение нагрузки"},
    "Temperature Limiter": {en: "Temperature Limiter", ru: "Температура ограничения нагрева"},
    "Temperature Limiter Trip Settings": {en: "Temperature Limiter Trip Settings", ru: "Настройки защитного отключения по температуре нагрева"},

    "Absent": {en: "Absent", ru: "Отсутствует"},
    "Present": {en: "Present", ru: "Присутствует"},

    "Measure Period": {en: "Measure Period, s", ru: "Интервал измерения тока, c"},
    "Heater On Time": {en: "Heater On Time, s", ru: "Время, на которое включается кабель, c"},
    "Calibration Temperature 1": {en: "Calibration Temperature 1, °C", ru: "Калибровочная температура 1, °C"},
    "Calibration Temperature 2": {en: "Calibration Temperature 2, °C", ru: "Калибровочная температура 2, °C"},
    "Calibration Current 1": {en: "Calibration Current 1, A", ru: "Калибровочный ток 1, A"},
    "Calibration Current 2": {en: "Calibration Current 2, A", ru: "Калибровочный ток 2, A"},
    "Status DI": {en: "Status", ru: "Статус"},

    "DO_CH_STATUS_Off": {en: "Off", ru: "Выключено"},
    "DO_CH_STATUS_WaitCool": {en: "Waiting to cool", ru: "Ожидание охлаждения"},
    "DO_CH_STATUS_SoftStart": {en: "SoftStart", ru: "Плавный пуск"},
    "DO_CH_STATUS_TransitionProcess": {en: "Transition process", ru: "Переходный процесс"},
    "DO_CH_STATUS_On": {en: "On", ru: "Включено"},
    "DO_CH_STATUS_CurrentLimiting": {en: "Current limiting", ru: "Оганичени тока"},
    "DO_CH_STATUS_OverCurrent": {en: "Overcurrent", ru: "Превышение максимального тока"},
    "DO_CH_STATUS_Overheat": {en: "Overheat", ru: "Перегрев"},
    "control_mode_off": {en: "Heater Off", ru: "Выкл. линию"},
    "control_mode_on": {en: "Heater On", ru: "Вкл. линию"},
    "control_mode_cabble_current": {en: "Calibration by Current", ru: "Калибровка по току"},
    "SENSOR_RTD_CU_50_426": {en: "RTD M - 50", ru: "RTD M - 50"}, 
    "SENSOR_RTD_PT_50_385": {en: "RTD Pt - 50", ru: "RTD Pt - 50"}, 
    "SENSOR_RTD_PT_100_385": {en: "RTD Pt - 100", ru: "RTD Pt - 100"},
    "SENSOR_RTD_PT_50_391": {en: "RTD П - 50", ru: "RTD П - 50"}, 
    "SENSOR_RTD_PT_100_391": {en: "RTD П - 100", ru: "RTD П - 100"}, 
    "SENSOR_RTD_CU_100_426": {en: "RTD M - 100", ru: "RTD M - 100"}, 
    "SENSOR_RTD_PT_1000_385": {en: "RTD Pt - 1000", ru: "RTD Pt - 1000"}, 
    "SENSOR_RTD_PT_1000_391": {en: "RTD П - 1000", ru: "RTD П - 1000"}, 
    "SENSOR_RTD_NI_100": {en: "RTD Ni - 100", ru: "RTD Ni - 100"},
    "SENSOR_RTD_OHMS_1": {en: "RTD Ohm 1", ru: "RTD Ohm 1"},
    "SENSOR_RTD_OHMS_2": {en: "RTD Ohm 2", ru: "RTD Ohm 2"},
    "SENSOR_RTD_CU_50_428": {en: "RTD M - 50", ru: "RTD M - 50"}, 
    "SENSOR_RTD_CU_100_428": {en: "RTD M - 100", ru: "RTD M - 100"}, 
    "SENSOR_NAMUR_DI": {en: "DI", ru: "DI"},
    "SENSOR_INNER_KTY": {en: "INNER KTY", ru: "INNER KTY"},
    "SENSOR_TC_R": {en: "TC R", ru: "TC R"},
    "SENSOR_TC_S": {en: "TC S", ru: "TC S"},
    "SENSOR_TC_B": {en: "TC B", ru: "TC B"},
    "SENSOR_TC_J": {en: "TC J", ru: "TC J"},
    "SENSOR_TC_T": {en: "TC T", ru: "TC T"},
    "SENSOR_TC_K": {en: "TC K", ru: "TC K"},
    "SENSOR_TC_N": {en: "TC N", ru: "TC N"},
    "SENSOR_TC_A1": {en: "TC A1", ru: "TC A1"},
    "SENSOR_TC_A2": {en: "TC A2", ru: "TC A2"},
    "SENSOR_TC_A3": {en: "TC A3", ru: "TC A3"},
    "SENSOR_TC_L": {en: "TC L", ru: "TC L"},
    "SENSOR_TC_VOLTS_1": {en: "VOLTMETR V1,5", ru: "VOLTMETR V1,5"},
    "SENSOR_TC_VOLTS_2": {en: "VOLTMETR V0,15", ru: "VOLTMETR V0,15"},
    "SENSOR_TC_E": {en: "TC E", ru: "TC E"},
    "SENSOR_TC_M": {en: "TC M", ru: "TC M"},
    "SENSOR_CL_4_20": {en: "4 -20", ru: "4 - 20"},
    "SENSOR_CL_0_20": {en: "0 - 20", ru: "0 - 20"},
} ,"reports": {
    "Energy Profiles":{en: "Energy Profiles", ru: "Профили энергии"},
    "Energy Profiles Chart":{en: "Energy Profile Chart", ru: "График профилей энергии"},
    "Report request":{en: "Energy Profile Request", ru: "Запрос профиля энергии"},
    "Current_report": {selector: "#Current_report", en: "Current Energy Profile Status: ", ru: "Статус текущего профиля энергии "},
    "Start": {selector: "#Start", en: "Start", ru: "Начало"},
    "Stop": {selector: "#Stop", en: "Stop", ru: "Конец"},
    "Current_time": {selector: "#Current_time", en: "Current", ru: "Текущее"},
    "Wap": {selector: "#Wap", en: "Wa+", ru: "Wa+"},
    "Wbp": {selector: "#Wbp", en: "Wb+", ru: "Wb+"},
    "Wcp": {selector: "#Wcp", en: "Wc+", ru: "Wc+"},
    "Wan": {selector: "#Wan", en: "Wa-", ru: "Wa-"},
    "Wbn": {selector: "#Wbn", en: "Wb-", ru: "Wb-"},
    "Wcn": {selector: "#Wcn", en: "Wc-", ru: "Wc-"},
    "WQap": {selector: "#WQap", en: "WQa+", ru: "WQa+"},
    "WQbp": {selector: "#WQbp", en: "WQb+", ru: "WQb+"},
    "WQcp": {selector: "#WQcp", en: "WQc+", ru: "WQc+"},
    "WQan": {selector: "#WQan", en: "WQa-", ru: "WQa-"},
    "WQbn": {selector: "#WQbn", en: "WQb-", ru: "WQb-"},
    "WQcn": {selector: "#WQcn", en: "WQc-", ru: "WQc-"},
    "WS": {en: "WS", ru: "WS"},
    "Pap": {selector: "#Pap", en: "Pa+", ru: "Pa+"},
    "Pbp": {selector: "#Pbp", en: "Pb+", ru: "Pb+"},
    "Pcp": {selector: "#Pcp", en: "Pc+", ru: "Pc+"},
    "Pan": {selector: "#Pan", en: "Pa-", ru: "Pa-"},
    "Pbn": {selector: "#Pbn", en: "Pb-", ru: "Pb-"},
    "Pcn": {selector: "#Pcn", en: "Pc-", ru: "Pc-"},
    "Qap": {selector: "#Qap", en: "Qa+", ru: "Qa+"},
    "Qbp": {selector: "#Qbp", en: "Qb+", ru: "Qb+"},
    "Qcp": {selector: "#Qcp", en: "Qc+", ru: "Qc+"},
    "Qan": {selector: "#Qan", en: "Qa-", ru: "Qa-"},
    "Qbn": {selector: "#Qbn", en: "Qb-", ru: "Qb-"},
    "Qcn": {selector: "#Qcn", en: "Qc-", ru: "Qc-"},
    "Enable": {selector: "#Enable", en: "Enable ", ru: "Задействовать "},
    "Control": {selector: "#Control", en: "Control ", ru: "Управление "},
    "Period": {selector: "#Period", en: "Period, min ", ru: "Период, мин "},
    "Status": {en: "Status", ru: "Статус"},
    "Request_Report_Time": {selector: "#Request_Report_Time", en: "Request Energy Profile Date ", ru: "Дата запрашиваемого профиля энергии "},
    "send_reports_request": {en: "Request", ru: "Запросить"},
    "COMMAND_CLEAR_ENERGY": {en: "Reset Values", ru: "Сбросить счетчики"},
    "COMMAND_CLEAR_ENERGY_confirm_question": {en: "Are you sure you want to reset energy values?", ru: "Вы уверены, что хотите сбросить счетчики энергии?"},
    "COMMAND_CLEAR_MTHRS": {en: "Reset values", ru: "Сбросить счетчики"},
    "COMMAND_CLEAR_MTHRS_confirm_question": {en: "Are you sure you want to reset operating hours?", ru: "Вы уверены, что хотите сбросить счетчики моточасов?"},
    "set system time": {en: "Set system time", ru: "Установить системное время"},
    "system_time_setting_confirm_question": {en: "Are you sure you want to set system time on device?", ru: "Вы уверены, что хотите установить на устройство системное время?"},
    "Reports_table": {selector: "#Reports_table", en: "Energy Profile Table", ru: "Таблица значений"},
    //"Chart_name": {selector: "#Chart_name", en: "Chart", ru: "График"},
    "No data": {en: "No Data", ru: "Нет данных за данный период"},
    "Device off": {en: "No Data", ru: "Нет данных"},
    "P+": {en: "Power Active Positive", ru: "Мощность активная прямая"},
    "P-": {en: "Power Active Negative", ru: "Мощность активная обратная"},
    "Q+": {en: "Power Reactive Positive", ru: "Мощность реактивная прямая"},
    "Q-": {en: "Power Reactive Negative", ru: "Мощность реактивная обратная"},
    "power_sum": {en: "Total Power", ru: "Суммарная мощность"},
    "W+": {en: "Energy Active Positive", ru: "Энергия активная прямая"},
    "W-": {en: "Energy Active Negative", ru: "Энергия активная обратная"},
    "WQ+": {en: "Energy Reactive Positive", ru: "Энергия реактивная прямая"},
    "WQ-": {en: "Energy Reactive Negative", ru: "Энергия реактивная обратная"},
    "total_energy": {en: "Apparent Energy", ru: "Суммарная энергия"},
    "Loading": {en: "Loading", ru: "Загрузка"},
    "Enable report recording": {en: "Energy Profile Recording", ru: "Запись профиля энергии"},
    "REPORT_FLAG_OK": {en: "Full energy profile", ru: "Запись проведена полностью"},
    "REPORT_FLAG_NOT_FULL": {en: "Not full energy profile", ru: "Запись завершена раньше периода"},
    "REPORT_FLAG_ENERGY_CLEANED": {en: "Energy cleaned", ru: "Сбросили энергию"},
    "REPORT_FLAG_TIME_SHIFT_FORWARD": {en: "Time shift forward", ru: "Время сдвинуто вперёд"},
    "REPORT_FLAG_TIME_SHIFT_BACKWARD": {en: "Time shift backward", ru: "Время сдвинуто назад"},
    "REPORT_FLAG_TIME_CHANGED": {en: "Time changed", ru: "Время поменяли"},
    "REPORT_FLAG_PREVIUOS_REPORT": {en: "Previuos energy profile writed, last record", ru: "Дописан предыдущий профиль энергии, последняя запись"},
} ,"modbus mappings": {
    "Registr": {en: "Register", ru: "Регистр"},
    "Name Index - subindex": {en: "Name Index - Subindex", ru: "Наименование индекса - субиндекса"},
    "AccessType": {en: "Access Type", ru: "Тип доступа"},
    "Comment": {en: "Comment", ru: "Комментарий"},
    "DataType": {en: "Data Type", ru: "Тип данных"},
    "Eds Index": {en: "Index:Subi", ru: "Индекс EDS"},
    "double_registr_misstake": {en: "Modbus mapping mistake: register number was specified several times.", ru: "Ошибка в modbus mapping: регистр указан несколько раз."},
}},



/**
 * Returns user browser locale (two-digits code)
 */
get_browser_locale : function() {
    return (navigator.language || navigator.systemLanguage || navigator.browserLanguage || navigator.userLanguage || this.default_locale).substr(0, 2).toLowerCase();
},

/**
 * Add page localizationn dictionary to localization object
 * @param page_name (required) - page codename
 * @param page_strings (optional) - l10n dictionary
 */
add_page: function(page_name, page_strings) {
    if (page_name) {
        this.pages[page_name] = page_strings;
        return true;
    }
    return false;
},

/**
 * Localize element by codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 * @param custom_locale (optional) - custom locale codename
 */
localize: function(name, custom_page, custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    var l10n_object = this.get_l10n_object(name, custom_page);
    if (!l10n_object) return false;

    // Try to get localization
    var l10n_string = l10n_object[loc];
    if (!l10n_string) {
        // In case of failure, try to get default localization
        l10n_string = l10n_object[this.default_locale];
        // If not default localization - fail
        if (!l10n_string) return false;
    }

    // Localizing element
    $(l10n_object.selector).html(l10n_string);
    return true;
},

/**
 * Returns localized string for codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 * @param custom_locale (optional) - custom locale codename
 */
localize_string: function(name, custom_page, custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    var l10n_object = this.get_l10n_object(name, custom_page);
    if (!l10n_object) return "";

    // Try to get localization
    var l10n_string = l10n_object[loc];
    if (!l10n_string) {
        // In case of failure, try to get default localization
        l10n_string = l10n_object[this.default_locale];
        // If not default localization - fail
        if (!l10n_string) return "";
    }

    // Returns localized string
    return l10n_string;
},

/**
 * Localize entire page by page codename
 * @param page (required) - page codename
 * @param custom_locale (optional) - custom locale codename
 * @param no_always (optional) - if true, ignore always_localize pages
 */
localize_page: function(page, custom_locale, no_always) {
    if (!page) return false;
    var loc = custom_locale || this.locale || this.default_locale;

    var strings = this.pages[page];
    for (var string_id in strings) {
        var string = strings[string_id];
        var l10n_string = string[loc];
        if (!l10n_string) {
            l10n_string = string[this.default_locale];
        }
        $(string.selector).html(l10n_string);
    }

    if (!no_always) {
        for (var page in this.always_localize) {
            this.localize_page(this.always_localize[page], loc, true);
        }
    }

    return true;
},

/**
 * Localize entire all pages (may be slow)
 * @param custom_locale (optional) - custom locale codename
 */
localize_all_pages: function(custom_locale) {
    var loc = custom_locale || this.locale || this.default_locale;

    for (var page_name in this.pages) {
        this.localize_page(page_name, loc, true);
    }

    for (var page in this.always_localize) {
        this.localize_page(this.always_localize[page], loc, true);
    }

    return true;
},

/**
 * (private method) Returns localization object by string codename
 * @param name (required) - string codename
 * @param custom_page (optional) - page codename, if not provided causes full scan for string codename
 */
get_l10n_object: function(name, custom_page) {
     // If custom_page not provided start full search
    // until first occurrence of string codename
    var page = custom_page;
    var found = false;
    if (!page) {
        for (var page_name in this.pages) {
            var strings = this.pages[page_name];
            for (var string_id in strings) {
                if (string_id == name) {
                    page = page_name;
                    found = true;
                    break;
                }
            }
            if (found) break;
        }
    }
//console.log("name =" +name)
//console.log("custom_page =" +custom_page)
//console.log("page =" + page)
    if (found == false) {
//console.log("l100n.js Not found name = \"" +name + "\"")
//var l10n_object = {selector: "", en: name, ru: name};
//return l10n_object;
        return this.pages[page][name]; // for view error
    } else {
//console.log("found name = \"" + this.pages[page][name]+"\"")
        return this.pages[page][name];
    }
},

change_locale: function() {
    if ($('#select_language').val() == 'en')
    {
        document.cookie = "language=en; max-age=24*3600"
        //$('.language').removeClass("ru")
        //$('#language').text('en')
    }
    else if ($('#select_language').val() == 'ru')
    {
        document.cookie = "language=ru; max-age=24*3600"
        //$('.language').addClass("ru")
        //$('#language').text('ru')
    }
    location.reload()
},

show_locale: function() {

    var select = $('<select id="select_language">')
    select.append($('<option>').val("ru").text("Русский"))
    select.append($('<option>').val("en").text("English"))
    var button = $(`<input type="submit" onclick="l100n.change_locale()">`).val(l100n.localize_string("apply_button"))
    var form = $('<form>').append(select).append(button).addClass('apply_form')
    $('#language').append(form)

    if (get_cookie_locale() == "ru")
    {
        //$('.language').addClass("ru")

        $('#select_language').val('ru')
    }
    else
    {
        $('#select_language').val('en')
    }
}
}

function getCookie(name) {
	let matches = document.cookie.match(new RegExp(
	  "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
	));
    return matches ? decodeURIComponent(matches[1]) : undefined
}

function get_cookie_locale()
{
    var locale = getCookie("language")
    if (locale == undefined)
    {
        locale = "en"
    }
    return locale
}

$(document).ready(function()
{
    $.datepicker.regional['ru'] = {
        closeText: 'Закрыть',
        prevText: 'Предыдущий',
        nextText: 'Следующий',
        currentText: 'Сегодня',
        monthNames: ['Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],
        monthNamesShort: ['Янв','Фев','Мар','Апр','Май','Июн','Июл','Авг','Сен','Окт','Ноя','Дек'],
        dayNames: ['воскресенье','понедельник','вторник','среда','четверг','пятница','суббота'],
        dayNamesShort: ['вск','пнд','втр','срд','чтв','птн','сбт'],
        dayNamesMin: ['Вс','Пн','Вт','Ср','Чт','Пт','Сб'],
        weekHeader: 'Не',
        dateFormat: 'yy-mm-dd',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };

    $.datepicker.regional['en'] = {
        dateFormat: 'yy-mm-dd',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };


    $.datepicker.setDefaults($.datepicker.regional[get_cookie_locale()])
})
